#include <genesis.h>
#include "player.h"
#include "enemies.h"


int main()
{
    VDP_setScreenWidth256();
    SPR_init();

    createPlayer();
    createEnemies(); 

    while(1)
    {
        SPR_update();
        manageEnemies();
        SYS_doVBlankProcess();
        
    }
    return (0);
}

///////////////////NOTES////////////////

/*

1. I've added two additional enemy sprites and updated the necessary .res and .h/.c files
to make the tutorial closer to what you see in the Pigsy tutorial. 

I had to use PAL1 for the additional sprites so this may cause issues unless I start editing sprite colors. 

2. The old code has the sly and bee sprite facing the opposite direction. I assume Pigsy is going to 
add code to handle enemy logic in a later lesson so I'm leaving it as-is for now. 

Here's a detailed summary of what's happening with the createEnemies() function in this lesson and
why it's a little different than the on in the Pigsy lesson. 

1. Palette Assignment
PAL_setPalette(PAL2, img_snail.palette->data, DMA);
PAL_setPalette(PAL1, img_bee.palette->data, DMA);


What palettes are:
On the Sega Genesis, sprites use “palettes,” each containing 16 colors. 
Each sprite must be assigned to one of the hardware palettes (PAL0–PAL3).

What these calls do:

Load the snail graphics' palette into hardware palette slot PAL2.

Load the bee graphics' palette into hardware palette slot PAL1.

DMA means the palette data is copied using Direct Memory Access, which is faster.

This sets up the colors the enemies' graphics will use.

2. Looping Through Enemy Array
for (u8 i = 0; i < 10; i++)


There are 10 enemy “slots.”

Each slot represents one potential enemy.

3. Check if the Enemy Slot Is Active
if (current_enemies[i].status != 0)


status != 0 means the enemy slot is in use.

Probably status == 0 means inactive or dead.

Only active enemies get sprites created for them.

4. Palette Selection Logic
u8 pal = (i <= 1) ? PAL2 : (i <= 3) ? PAL1 : PAL0;


This uses nested ternary operators to choose a palette based on the enemy’s index:

Enemy 0–1 → use palette PAL2
These are snails & flies (based on earlier palette assignment from Little Nemo sprite assets).

Enemy 2–3 → use palette PAL1
These are bees and crabs. (Sonic 2 sprite assets)

Enemy 4–9 → use PAL0
A fallback for rows or enemy types not assigned a palette in this function.

This is a simple way to map specific enemies to specific palettes.

5. Create the Sprite
current_enemies[i].sprite = SPR_addSprite(
    current_enemies[i].graphic,
    fix32ToInt(current_enemies[i].x),
    fix32ToInt(current_enemies[i].y),
    TILE_ATTR(pal, FALSE, FALSE, FALSE)
);


This is the core of the function.

Parameters Explained:

current_enemies[i].graphic
A pointer to the sprite graphic (SpriteDefinition*).

fix32ToInt(current_enemies[i].x) and y

Enemy positions are stored in fixed-point format (fix32).

The function converts them to integer pixel coordinates.

TILE_ATTR(...) creates a tile attribute value:

pal — palette index chosen above.

FALSE — no horizontal flip.

FALSE — no vertical flip.

FALSE — priority flag (0 = default priority).

What SPR_addSprite does:

Allocates a new sprite in SGDK’s internal sprite engine.

Places it on screen at the chosen position.

Returns a Sprite* reference.
This pointer is stored back into current_enemies[i].sprite, so the game can update or remove the sprite later.

Summary
In plain English:

createEnemies() loads palettes for enemy graphics, then loops through all enemy slots. 
For each active enemy, it chooses a palette based on its index, converts its fixed-point coordinates to screen coordinates, 
and creates a sprite for it using SGDK’s sprite system. 

Each newly created sprite is stored back in the enemy’s struct for later use.

What it accomplishes:

Initializes enemy sprites only for active enemies.

Ensures each enemy uses the correct palette.

Makes all enemies appear visually on the screen.

*/

/////////////////////////////////////////